#Author: Dr.Pattabiraman.V, Professor, School of Computing Science & Engineering, VIT Chennai
#Ex4 - Visualization of Network and it's Node descriptive 
#R version 3.6.2 (2019-12-12)
#RStudio version 1.2.1335
library(igraph)
g4 <- graph( c('Susann', 'Jeag4te', 'Harrison', 'Myron', 'Julie', 'Colten', 'Brandyn', 'Leland', 'Catherine', 'Tracy', 'Bee', 'Maureen', 'Annika', 'Hans', 'Spenser', 'Angelo', 'Blanche', 'Stanford', 'Hope', 'Catherine', 'Almira', 'Thomas', 'Henry', 'Ralph', 'Louvenia', 'German', 'Lura', 'Wilma', 'Lauretta', 'Maudie', 'Martha', 'Henry', 'Loyd', 'Mayra', 'Noelle', 'Fabian', 'Ira', 'Zenobia', 'Noelle', 'Natalie', 'Brooke', 'German', 'Lauretta', 'Zenobia', 'Hallie', 'Braxton', 'Lorraine', 'Alicia', 'Allie', 'Jaylon', 'Myrna', 'Darrel', 'Lura', 'Hermon', 'Wyatt', 'Raoul', 'Althea', 'Laurel', 'Leola', 'Darrel', 'Giles', 'Merritt', 'Angelo', 'Kendrick', 'Travis', 'Henry', 'Owen', 'Almira', 'Michelle', 'Lou', 'Stephan', 'Leola', 'Wyatt', 'Allie', 'Eli', 'Brandyn', 'Mayra', 'Chin', 'Clarance', 'Marlee', 'Glenn', 'Reid', 'Glenn', 'Jerrold', 'Dale', 'Helena', 'Alvie', 'Elden', 'Chaim', 'Merritt', 'Augustine', 'Curtiss', 'Alvie', 'Allie', 'Pollie', 'Catherine', 'Angelita', 'Glenn', 'Allie', 'Braden', 'Manford', 'Raoul', 'Dwight', 'Pollie', 'Zona', 'Reggie', 'Dominic', 'Amy', 'Santos', 'Faron', 'Leslie', 'Etha', 'Maureen', 'Juanita', 'Gust', 'Noelle', 'Darrel', 'Darin', 'Faron', 'Zona', 'Myron', 'Hans', 'German', 'Elden', 'Mayra', 'Merritt', 'Myron', 'Gerald', 'Andrea', 'German', 'Angelita', 'Giles', 'Reggie', 'Wyatt', 'Alvie', 'Darrel', 'Jarrett', 'Newell', 'Brandyn', 'Eloisa', 'Santos', 'Lou', 'Quintin', 'Zechariah', 'Leola', 'Anthony', 'Eliga', 'Gust', 'Obie', 'Obie', 'Brandyn', 'Brooke', 'Dominic', 'Jacoby', 'Maureen', 'Hardie', 'Noelle', 'Braxton', 'Noelle', 'Leola', 'Marlee', 'Helena', 'Ira', 'Kermit', 'Wilda', 'Eli', 'Chance', 'Hardie', 'Andrea', 'Johnnie', 'Lauretta', 'Tracy', 'Kathryn', 'Spenser', 'Lou', 'Dana', 'Dominic', 'Rachelle', 'Glenn', 'Darrel', 'Deidra', 'Orpha', 'Hermon', 'Rosalind', 'Hans', 'Curtis', 'Josue', 'Wyatt', 'Agatha', 'Wyatt', 'Chance', 'Glenn', 'Kendrick', 'Brooke', 'Hollie', 'Beverly', 'Katarina', 'Josue', 'Leslie', 'Colten', 'Mayra', 'Darin', 'Hermon', 'Myron', 'Alicia', 'Leila', 'Kermit', 'Lamar', 'Dana', 'Johnnie', 'Althea', 'Judson', 'Colten', 'Hope', 'Gust', 'Clarance', 'Leland', 'Matthew', 'Lorraine', 'Althea', 'Colten', 'Jewel', 'Leila', 'Eli', 'Zenobia', 'German', 'Jaylon', 'Henry', 'Michelle', 'Johnie', 'Judson', 'Johnnie', 'Leslie', 'Wyatt', 'Lou', 'Maureen', 'Jacoby', 'Noelle', 'Johnnie', 'Alvie', 'Leila', 'Myron', 'Wilda', 'Brandyn', 'Kendrick', 'Gerald', 'Tyson', 'Jacoby', 'Ari', 'Theo', 'Harrison', 'Carmen', 'Leonard', 'Braden', 'Desi', 'Zona', 'Maureen', 'Ralph', 'Thomas', 'Myron', 'Austin', 'Leola', 'Loyd', 'Quintin', 'Lorraine', 'Glenn', 'Merritt', 'Janet', 'Myron', 'Alicia', 'Maureen', 'Leslie', 'Carla', 'Vicky', 'Harley', 'Leslie', 'Hannah', 'Gust', 'Andrea', 'Giles', 'Wilma', 'Henry', 'Hermon', 'Stefani', 'Henry', 'Harley', 'Noelle', 'Kermit', 'Laurel', 'Hermon', 'Sebastian', 'Andrea', 'Eliga', 'Sigmund', 'Darrel', 'Noelle', 'Urban', 'Almira', 'Noelle', 'Dwight', 'Beverly', 'Wyatt', 'Juanita', 'Reid', 'Kermit', 'Myrna', 'Pollie', 'Hope', 'Leola', 'Leslie', 'Jacoby', 'Pollie', 'Tiffany', 'Gust', 'Leland', 'Eliga', 'Lamar', 'Ira', 'Dale', 'Noelle', 'Jarrett', 'Zenobia', 'Orpha', 'Glenn', 'Amy', 'Hermon', 'Myrna', 'Brandyn', 'Nell', 'Leslie', 'Edd', 'Lura', 'Kendrick', 'Obie', 'Augustine', 'Zona', 'Glenn', 'Dominic', 'Jennifer', 'Rachelle', 'Faron', 'Darrel', 'Pollie', 'Almira', 'Glenn', 'Wilma', 'Angus', 'Leila', 'Sherri'))
V(g4)$name
V(g4)$part <- c('teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'student', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'student', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'teacher', 'student', 'teacher', 'teacher', 'student', 'student', 'teacher', 'teacher', 'student', 'teacher', 'student', 'student', 'student')
E(g4)$type <- "knows" 
g4 <- set.edge.attribute(g4, "weight", value=runif(ecount(g4)))

edge_density(g4, loops=F)
ecount(g4)/(vcount(g4)*(vcount(g4)-1))


reciprocity(g4)
dyad_census(g4) # Mutual, asymmetric, and nyll node pairs
2*dyad_census(g4)$mut/ecount(g4) # Calculating reciprocity



transitivity(g4, type="global")  # g4 is treated as an undirected network
transitivity(as.undirected(g4, mode="collapse")) # same as above
transitivity(g4, type="local")
triad_census(g4) # for directed networks 


diameter(g4, directed=F, weights=NA)
diameter(g4, directed=F)
diam <- get_diameter(g4, directed=T)
diam
class(diam)
as.vector(diam)
vcol <- rep("gray40", vcount(g4))

vcol[diam] <- "gold"

ecol <- rep("gray80", ecount(g4))

ecol[E(g4, path=diam)] <- "orange" 

E(g4, path=diam) #finds edges along a path, here 'diam'

plot(g4, vertex.color=vcol, edge.color=ecol, edge.arrow.mode=0)

deg <- degree(g4, mode="all")

plot(g4, vertex.size=deg*3)


hist(deg, breaks=1:vcount(g4)-1, main="Histogram of node degree")


deg.dist <- degree_distribution(g4, cumulative=T, mode="all")
plot( x=0:max(g4), y=1-deg.dist, pch=19, cex=1.2, col="orange",
      xlab="Degree", ylab="Cumulative Frequency")



degree(g4, mode="in")
centr_degree(g4, mode="in", normalized=T)



closeness(g4, mode="all", weights=NA) 
centr_clo(g4, mode="all", normalized=T)


eigen_centrality(g4, directed=T, weights=NA)
centr_eigen(g4, directed=T, normalized=T)


betweenness(g4, directed=T, weights=NA)
edge_betweenness(g4, directed=T, weights=NA)
centr_betw(g4, directed=T, normalized=T)



hs <- hub_score(g4, weights=NA)$vector
as <- authority_score(g4, weights=NA)$vector
par(mfrow=c(1,2))
plot(g4, vertex.label=NA, edge.arrow.size=.05, vertex.size=hs*100, main="Hubs")
plot(g4, vertex.label=NA, edge.arrow.size=.05, vertex.size=as*60, main="Authorities")

